#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BatchPredictionJobTimeSeriesSettingsHistorical(APIObject):
    """
    Attributes
    ----------
    type:str
         Historical mode enables bulk predictions which calculates predictions for all possible forecast points and forecast distances in the dataset within the predictionsStartDate/predictionsEndDate range.. defaults to "historical", must be one of ["historical", ]
    predictions_end_date:datetime [optional]
         Used for historical predictions in order to override date to which predictions should be calculated. By default value will be inferred automatically from the dataset.. 
    predictions_start_date:datetime [optional]
         Used for historical predictions in order to override date from which predictions should be calculated. By default value will be inferred automatically from the dataset.. 
    relax_known_in_advance_features_check:bool [optional]
         If activated, missing values in the known in advance features are allowed in the forecast window at prediction time. If omitted or false, missing values are not allowed..  if omitted the server will use the default value of False
    """
    _converter = t.Dict(
        {
            t.Key("type"):  t.String(),
            t.Key("predictions_end_date", optional=True):  t.DateTime(),
            t.Key("predictions_start_date", optional=True):  t.DateTime(),
            t.Key("relax_known_in_advance_features_check", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        type,
        predictions_end_date=None,
        predictions_start_date=None,
        relax_known_in_advance_features_check=None,
    ):
        self.type = type
        self.predictions_end_date = predictions_end_date
        self.predictions_start_date = predictions_start_date
        self.relax_known_in_advance_features_check = relax_known_in_advance_features_check

    def __repr__(self):
        return (
            "BatchPredictionJobTimeSeriesSettingsHistorical("
            "type={0.type}, "
            "predictions_end_date={0.predictions_end_date}, "
            "predictions_start_date={0.predictions_start_date}, "
            "relax_known_in_advance_features_check={0.relax_known_in_advance_features_check}, "
        ).format(self)
