#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BatchPredictionJobUpdate(APIObject):
    """
    Attributes
    ----------
    aborted:datetime, none_type [optional]
         Time when job abortion happened. 
    completed:datetime, none_type [optional]
         Time when job completed scoring. 
    failed_rows:int [optional]
         Number of rows that have failed scoring. 
    hidden:bool [optional]
         Hides or unhides the job from the job list. 
    job_intake_size:int, none_type [optional]
         Number of bytes in the intake dataset for this job. 
    job_output_size:int, none_type [optional]
         Number of bytes in the output dataset for this job. 
    logs:[str] [optional]
         The job log.. 
    scored_rows:int [optional]
         Number of rows that have been successfully scored. 
    skipped_rows:int [optional]
         Number of rows that have been skipped during scoring. May contain non-zero value only in time-series predictions case if provided dataset contains more than required historical rows.. 
    started:datetime, none_type [optional]
         Time when job scoring begin. 
    status:str [optional]
         The current job status. 
    """
    _converter = t.Dict(
        {
            t.Key("aborted", optional=True):  t.DateTime(),
            t.Key("completed", optional=True):  t.DateTime(),
            t.Key("failed_rows", optional=True):  t.Int(),
            t.Key("hidden", optional=True):  t.Bool(),
            t.Key("job_intake_size", optional=True):  t.Int(),
            t.Key("job_output_size", optional=True):  t.Int(),
            t.Key("logs", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("scored_rows", optional=True):  t.Int(),
            t.Key("skipped_rows", optional=True):  t.Int(),
            t.Key("started", optional=True):  t.DateTime(),
            t.Key("status", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        aborted=None,
        completed=None,
        failed_rows=None,
        hidden=None,
        job_intake_size=None,
        job_output_size=None,
        logs=None,
        scored_rows=None,
        skipped_rows=None,
        started=None,
        status=None,
    ):
        self.aborted = aborted
        self.completed = completed
        self.failed_rows = failed_rows
        self.hidden = hidden
        self.job_intake_size = job_intake_size
        self.job_output_size = job_output_size
        self.logs = logs
        self.scored_rows = scored_rows
        self.skipped_rows = skipped_rows
        self.started = started
        self.status = status

    def __repr__(self):
        return (
            "BatchPredictionJobUpdate("
            "aborted={0.aborted}, "
            "completed={0.completed}, "
            "failed_rows={0.failed_rows}, "
            "hidden={0.hidden}, "
            "job_intake_size={0.job_intake_size}, "
            "job_output_size={0.job_output_size}, "
            "logs={0.logs}, "
            "scored_rows={0.scored_rows}, "
            "skipped_rows={0.skipped_rows}, "
            "started={0.started}, "
            "status={0.status}, "
        ).format(self)
