#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BiasAndFairness(APIObject):
    """
    Attributes
    ----------
    fairness_metrics_set:str
         A set of fairness metrics to use for calculating fairness.
    fairness_threshold:float
         Threshold value of the fairness metric. Can be in a range of ``[0:1]``.
    preferable_target_value:bool, date, datetime, dict, float, int, list, str, none_type
         A target value that should be treated as a positive outcome for the prediction. For example if we want to check gender discrimination for giving a loan and our target named ``is_bad``, then the positive outcome for the prediction would be ``No``, meaning that the loan is good and that's what we treat as a preferable result for the loaner.
    protected_features:[str]
         A list of feature to mark as protected for Bias and Fairness measurement. A common example of those would `race`, `gender`, `age_group`. All protected features should be tracked as segment attributes. Only categorical features can be marked as protected.
    """
    _converter = t.Dict(
        {
            t.Key("fairness_metrics_set"):  t.String(),
            t.Key("fairness_threshold"):  t.Float(),
            t.Key("preferable_target_value"):  t.Any(),
            t.Key("protected_features"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        fairness_metrics_set,
        fairness_threshold,
        preferable_target_value,
        protected_features,
    ):
        self.fairness_metrics_set = fairness_metrics_set
        self.fairness_threshold = fairness_threshold
        self.preferable_target_value = preferable_target_value
        self.protected_features = protected_features

    def __repr__(self):
        return (
            "BiasAndFairness("
            "fairness_metrics_set={0.fairness_metrics_set}, "
            "fairness_threshold={0.fairness_threshold}, "
            "preferable_target_value={0.preferable_target_value}, "
            "protected_features={0.protected_features}, "
        ).format(self)
