#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.bias_vs_accuracy_models import BiasVsAccuracyModels

class BiasVsAccuracyInsight(APIObject):
    """
    Attributes
    ----------
    fairness_threshold:float
         Value of the fairness threshold, defined in project options.. defaults to 0.8
    models:[BiasVsAccuracyModels]
         An array of models of the insight.
    accuracy_metric:str [optional]
         The metric to return model accuracy scores. Defaults to the optimization metric configured in project options.. 
    fairness_metric:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The fairness metric used to calculate the fairness scores.. 
    protected_feature:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Name of the protected feature.. 
    """
    _converter = t.Dict(
        {
            t.Key("fairness_threshold"):  t.Float(),
            t.Key("models"):  t.List(t.Dict().allow_extra("*")),
            t.Key("accuracy_metric", optional=True):  t.String(),
            t.Key("fairness_metric", optional=True):  t.Any(),
            t.Key("protected_feature", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        fairness_threshold,
        models,
        accuracy_metric=None,
        fairness_metric=None,
        protected_feature=None,
    ):
        self.fairness_threshold = fairness_threshold
        self.models = models
        self.accuracy_metric = accuracy_metric
        self.fairness_metric = fairness_metric
        self.protected_feature = protected_feature

    def __repr__(self):
        return (
            "BiasVsAccuracyInsight("
            "fairness_threshold={0.fairness_threshold}, "
            "models={0.models}, "
            "accuracy_metric={0.accuracy_metric}, "
            "fairness_metric={0.fairness_metric}, "
            "protected_feature={0.protected_feature}, "
        ).format(self)
