#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BiasVsAccuracyModels(APIObject):
    """
    Attributes
    ----------
    accuracy_value:float
         The model's accuracy score.
    bp:int
         The blueprint number of the model from the leaderboard.
    ds_name:str
         The name of the feature list used for model training.
    fairness_value:float
         The model's relative fairness score for the class with the lowest fairness score. In other words, the fairness score of the least privileged class.
    model_id:str
         ID of the model.
    model_number:int
         The model number from the leaderboard.
    model_type:str
         The type/name of the model.
    prime:bool
         Flag to indicate whether the model is a prime model.
    samplepct:float
         The sample size percentage of the feature list data the model was trained on.
    """
    _converter = t.Dict(
        {
            t.Key("accuracy_value"):  t.Float(),
            t.Key("bp"):  t.Int(),
            t.Key("ds_name"):  t.String(),
            t.Key("fairness_value"):  t.Float(),
            t.Key("model_id"):  t.String(),
            t.Key("model_number"):  t.Int(),
            t.Key("model_type"):  t.String(),
            t.Key("prime"):  t.Bool(),
            t.Key("samplepct"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        accuracy_value,
        bp,
        ds_name,
        fairness_value,
        model_id,
        model_number,
        model_type,
        prime,
        samplepct,
    ):
        self.accuracy_value = accuracy_value
        self.bp = bp
        self.ds_name = ds_name
        self.fairness_value = fairness_value
        self.model_id = model_id
        self.model_number = model_number
        self.model_type = model_type
        self.prime = prime
        self.samplepct = samplepct

    def __repr__(self):
        return (
            "BiasVsAccuracyModels("
            "accuracy_value={0.accuracy_value}, "
            "bp={0.bp}, "
            "ds_name={0.ds_name}, "
            "fairness_value={0.fairness_value}, "
            "model_id={0.model_id}, "
            "model_number={0.model_number}, "
            "model_type={0.model_type}, "
            "prime={0.prime}, "
            "samplepct={0.samplepct}, "
        ).format(self)
