#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BigQueryIntake(APIObject):
    """
    Attributes
    ----------
    bucket:str
         The name of gcs bucket for data export
    dataset:str
         The name of the specified big query dataset to read input data from
    table:str
         The name of the specified big query table to read input data from
    type:str
         Type name for this intake type. defaults to "bigquery", must be one of ["bigquery", ]
    credential_id:str, none_type [optional]
         The ID of the GCP credentials. 
    """
    _converter = t.Dict(
        {
            t.Key("bucket"):  t.String(),
            t.Key("dataset"):  t.String(),
            t.Key("table"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("credential_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bucket,
        dataset,
        table,
        type,
        credential_id=None,
    ):
        self.bucket = bucket
        self.dataset = dataset
        self.table = table
        self.type = type
        self.credential_id = credential_id

    def __repr__(self):
        return (
            "BigQueryIntake("
            "bucket={0.bucket}, "
            "dataset={0.dataset}, "
            "table={0.table}, "
            "type={0.type}, "
            "credential_id={0.credential_id}, "
        ).format(self)
