#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BinResponse(APIObject):
    """
    Attributes
    ----------
    avg_predicted:float, none_type
         Average prediction of the model in the bin. Null if there are no entries in the bin.
    end_date:datetime
         ISO-formatted datetime of the end of the bin (exclusive).
    frequency:int
         Number of the rows in the bin.
    max_predicted:float, none_type
         Maximum prediction of the model in the bin. Null if there are no entries in the bin.
    start_date:datetime
         ISO-formatted datetime of the start of the bin (inclusive).
    """
    _converter = t.Dict(
        {
            t.Key("avg_predicted"):  t.Float(),
            t.Key("end_date"):  t.DateTime(),
            t.Key("frequency"):  t.Int(),
            t.Key("max_predicted"):  t.Float(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        avg_predicted,
        end_date,
        frequency,
        max_predicted,
        start_date,
    ):
        self.avg_predicted = avg_predicted
        self.end_date = end_date
        self.frequency = frequency
        self.max_predicted = max_predicted
        self.start_date = start_date

    def __repr__(self):
        return (
            "BinResponse("
            "avg_predicted={0.avg_predicted}, "
            "end_date={0.end_date}, "
            "frequency={0.frequency}, "
            "max_predicted={0.max_predicted}, "
            "start_date={0.start_date}, "
        ).format(self)
