#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BlenderCreate(APIObject):
    """
    Attributes
    ----------
    blender_method:str
         The blender method, one of \"PLS\", \"GLM\", \"AVG\", \"ENET\", \"MED\", \"MAE\", \"MAEL1\", \"TF\", \"RF\", \"LGBM\", \"FORECAST_DISTANCE_ENET\" (new in v2.18), \"FORECAST_DISTANCE_AVG\" (new in v2.18), \"MIN\", \"MAX\".
    model_ids:[str]
         The list of models to use in blender.
    """
    _converter = t.Dict(
        {
            t.Key("blender_method"):  t.String(),
            t.Key("model_ids"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        blender_method,
        model_ids,
    ):
        self.blender_method = blender_method
        self.model_ids = model_ids

    def __repr__(self):
        return (
            "BlenderCreate("
            "blender_method={0.blender_method}, "
            "model_ids={0.model_ids}, "
        ).format(self)
