#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.blender_retrieve_response import BlenderRetrieveResponse

class BlenderListResponse(APIObject):
    """
    Attributes
    ----------
    count:int
         Number of items returned on this page.
    data:[BlenderRetrieveResponse]
         Each has the same schema as if retrieving the model individually from :http:get:`/api/v2/projects/(projectId)/blenderModels/(modelId)/`.
    next:str, none_type
         URL pointing to the next page (if null, there is no next page).
    previous:str, none_type
         URL pointing to the previous page (if null, there is no previous page).
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        data,
        next,
        previous,
    ):
        self.count = count
        self.data = data
        self.next = next
        self.previous = previous

    def __repr__(self):
        return (
            "BlenderListResponse("
            "count={0.count}, "
            "data={0.data}, "
            "next={0.next}, "
            "previous={0.previous}, "
        ).format(self)
