#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.blueprint_doc_links import BlueprintDocLinks
from datarobot.models.full_api.generated.model.blueprint_doc_parameters import BlueprintDocParameters
from datarobot.models.full_api.generated.model.blueprint_doc_references import BlueprintDocReferences

class BlueprintListDocumentsResponse(APIObject):
    """
    Attributes
    ----------
    description:str
         The task description.
    links:[BlueprintDocLinks]
         A list of external documentation links.
    parameters:[BlueprintDocParameters]
         An array of task parameters.
    references:[BlueprintDocReferences]
         A list of reference links.
    task:str
         The task described in document.
    title:str
         The document title.
    """
    _converter = t.Dict(
        {
            t.Key("description"):  t.String(),
            t.Key("links"):  t.List(t.Dict().allow_extra("*")),
            t.Key("parameters"):  t.List(t.Dict().allow_extra("*")),
            t.Key("references"):  t.List(t.Dict().allow_extra("*")),
            t.Key("task"):  t.String(),
            t.Key("title"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        description,
        links,
        parameters,
        references,
        task,
        title,
    ):
        self.description = description
        self.links = links
        self.parameters = parameters
        self.references = references
        self.task = task
        self.title = title

    def __repr__(self):
        return (
            "BlueprintListDocumentsResponse("
            "description={0.description}, "
            "links={0.links}, "
            "parameters={0.parameters}, "
            "references={0.references}, "
            "task={0.task}, "
            "title={0.title}, "
        ).format(self)
