#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BlueprintResponse(APIObject):
    """
    Attributes
    ----------
    blueprint_category:str
         describes the category of the blueprint and indicates the kind of model this blueprint produces. Will be either \"DataRobot\" or \"Scaleout DataRobot\".
    id:str
         the blueprint ID of this blueprint - note that this is not an ObjectId.
    model_type:str
         the model this blueprint will produce.
    monotonic_decreasing_featurelist_id:str, none_type
         the ID of the featurelist that defines the set of features with a monotonically decreasing relationship to the target. If null, no such constraints are enforced.
    monotonic_increasing_featurelist_id:str, none_type
         null or str, the ID of the featurelist that defines the set of features with a monotonically increasing relationship to the target. If null, no such constraints are enforced.
    processes:[str]
         a list of strings representing processes the blueprint uses.
    project_id:str
         the project the blueprint belongs to.
    recommended_featurelist_id:str, none_type
         The ID of the feature list recommended for this blueprint. If this field is not present, then there is no recommended feature list.
    supports_composable_ml:bool
         indicates whether this blueprint is supported in Composable ML.
    supports_monotonic_constraints:bool
         whether this model supports enforcing monotonic constraints.
    """
    _converter = t.Dict(
        {
            t.Key("blueprint_category"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("model_type"):  t.String(),
            t.Key("monotonic_decreasing_featurelist_id"):  t.String(),
            t.Key("monotonic_increasing_featurelist_id"):  t.String(),
            t.Key("processes"):  t.List(t.Dict().allow_extra("*")),
            t.Key("project_id"):  t.String(),
            t.Key("recommended_featurelist_id"):  t.String(),
            t.Key("supports_composable_ml"):  t.Bool(),
            t.Key("supports_monotonic_constraints"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        blueprint_category,
        id,
        model_type,
        monotonic_decreasing_featurelist_id,
        monotonic_increasing_featurelist_id,
        processes,
        project_id,
        recommended_featurelist_id,
        supports_composable_ml,
        supports_monotonic_constraints,
    ):
        self.blueprint_category = blueprint_category
        self.id = id
        self.model_type = model_type
        self.monotonic_decreasing_featurelist_id = monotonic_decreasing_featurelist_id
        self.monotonic_increasing_featurelist_id = monotonic_increasing_featurelist_id
        self.processes = processes
        self.project_id = project_id
        self.recommended_featurelist_id = recommended_featurelist_id
        self.supports_composable_ml = supports_composable_ml
        self.supports_monotonic_constraints = supports_monotonic_constraints

    def __repr__(self):
        return (
            "BlueprintResponse("
            "blueprint_category={0.blueprint_category}, "
            "id={0.id}, "
            "model_type={0.model_type}, "
            "monotonic_decreasing_featurelist_id={0.monotonic_decreasing_featurelist_id}, "
            "monotonic_increasing_featurelist_id={0.monotonic_increasing_featurelist_id}, "
            "processes={0.processes}, "
            "project_id={0.project_id}, "
            "recommended_featurelist_id={0.recommended_featurelist_id}, "
            "supports_composable_ml={0.supports_composable_ml}, "
            "supports_monotonic_constraints={0.supports_monotonic_constraints}, "
        ).format(self)
