#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BulkCatalogAppendTagsPayload(APIObject):
    """
    Attributes
    ----------
    action:str
         The action to execute on the datasets. Has to be 'tag' for this payload.. defaults to "tag", must be one of ["tag", ]
    tags:[str]
         The tags to append to the datasets. Tags will not be duplicated.
    """
    _converter = t.Dict(
        {
            t.Key("action"):  t.String(),
            t.Key("tags"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        action,
        tags,
    ):
        self.action = action
        self.tags = tags

    def __repr__(self):
        return (
            "BulkCatalogAppendTagsPayload("
            "action={0.action}, "
            "tags={0.tags}, "
        ).format(self)
