#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BulkCatalogSharePayload(APIObject):
    """
    Attributes
    ----------
    action:str
         The action to execute on the datasets. Has to be 'updateRoles' for this payload.. defaults to "updateRoles", must be one of ["updateRoles", ]
    roles:[bool, date, datetime, dict, float, int, list, str, none_type]
         An array of RoleRequest objects. May contain at most 100 such objects.
    apply_grant_to_linked_objects:bool [optional]
         If true for any users being granted access to the dataset, grant the user read access to any linked objects such as DataSources and DataStores that may be used by this dataset. Ignored if no such objects are relevant for dataset. Will not result in access being lowered for a user if the user already has higher access to linked objects than read access. However, if the target user does not have sharing permissions to the linked object, they will be given sharing access without lowering existing permissions. May result in an error if user making call does not have sufficient permissions to complete grant. Default value is false..  if omitted the server will use the default value of False
    """
    _converter = t.Dict(
        {
            t.Key("action"):  t.String(),
            t.Key("roles"):  t.List(t.Dict().allow_extra("*")),
            t.Key("apply_grant_to_linked_objects", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        action,
        roles,
        apply_grant_to_linked_objects=None,
    ):
        self.action = action
        self.roles = roles
        self.apply_grant_to_linked_objects = apply_grant_to_linked_objects

    def __repr__(self):
        return (
            "BulkCatalogSharePayload("
            "action={0.action}, "
            "roles={0.roles}, "
            "apply_grant_to_linked_objects={0.apply_grant_to_linked_objects}, "
        ).format(self)
