#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BulkDatasetAction(APIObject):
    """
    Attributes
    ----------
    dataset_ids:[str]
         The dataset IDs to execute the bulk action on.
    payload:bool, date, datetime, dict, float, int, list, str, none_type
         indicate which action to run and with what parameters.
    """
    _converter = t.Dict(
        {
            t.Key("dataset_ids"):  t.List(t.Dict().allow_extra("*")),
            t.Key("payload"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_ids,
        payload,
    ):
        self.dataset_ids = dataset_ids
        self.payload = payload

    def __repr__(self):
        return (
            "BulkDatasetAction("
            "dataset_ids={0.dataset_ids}, "
            "payload={0.payload}, "
        ).format(self)
