#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CalendarEvent(APIObject):
    """
    Attributes
    ----------
    date:datetime
         The date of the calendar event.
    name:str
         Name of the calendar event.
    series_id:str, none_type
         The series ID for the event. If this event does not specify a series ID, then this will be `null`, indicating that the event applies to all series.
    """
    _converter = t.Dict(
        {
            t.Key("date"):  t.DateTime(),
            t.Key("name"):  t.String(),
            t.Key("series_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        date,
        name,
        series_id,
    ):
        self.date = date
        self.name = name
        self.series_id = series_id

    def __repr__(self):
        return (
            "CalendarEvent("
            "date={0.date}, "
            "name={0.name}, "
            "series_id={0.series_id}, "
        ).format(self)
