#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CalendarFileUpload(APIObject):
    """
    Attributes
    ----------
    file:file_type
         The calendar file used to create a calendar. The calendar file expect to meet the following criteria:  Must be in a csv or xlsx format.  Must have a header row. The names themselves in the header row can be anything.  Must have a single date column, in YYYY-MM-DD format.  May optionally have a name column as the second column.  May optionally have one series ID column that states what series each event is applicable for. If present, the name of this column must be specified in the `multiseriesIdColumns` parameter.
    multiseries_id_columns:str [optional]
         An array of multiseries ID column names for the calendar file. Currently only one multiseries ID column is supported. If not specified, the calendar is considered to be single series.. 
    name:str [optional]
         The name of the calendar file. If not provided, this will be set to the name of the provided file.. 
    """
    _converter = t.Dict(
        {
            t.Key("file"):  t.String(),
            t.Key("multiseries_id_columns", optional=True):  t.String(),
            t.Key("name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        file,
        multiseries_id_columns=None,
        name=None,
    ):
        self.file = file
        self.multiseries_id_columns = multiseries_id_columns
        self.name = name

    def __repr__(self):
        return (
            "CalendarFileUpload("
            "file={0.file}, "
            "multiseries_id_columns={0.multiseries_id_columns}, "
            "name={0.name}, "
        ).format(self)
