#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CalendarFromDataset(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The ID of the dataset from which to create the calendar.
    dataset_version_id:str [optional]
         The ID of the dataset version from which to create the calendar.. 
    multiseries_id_columns:[str] [optional]
         Optional multiseries id columns for calendar.. 
    name:str [optional]
         Optional name for catalog.. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_version_id", optional=True):  t.String(),
            t.Key("multiseries_id_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        dataset_version_id=None,
        multiseries_id_columns=None,
        name=None,
    ):
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.multiseries_id_columns = multiseries_id_columns
        self.name = name

    def __repr__(self):
        return (
            "CalendarFromDataset("
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "multiseries_id_columns={0.multiseries_id_columns}, "
            "name={0.name}, "
        ).format(self)
