#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CalendarRecord(APIObject):
    """
    Attributes
    ----------
    created:datetime
         An ISO-8601 string with the time that this calendar was created.
    datetime_format:str
         The datetime format detected for the uploaded calendar file.
    earliest_event:datetime
         An ISO-8601 date string of the earliest event seen in this calendar.
    id:str
         The ID of this calendar.
    latest_event:datetime
         An ISO-8601 date string of the latest event seen in this calendar.
    multiseries_id_columns:[str], none_type
         An array of multiseries ID column names in this calendar file. Currently only one multiseries ID column is supported. Will be `null` if this calendar is single-series.
    name:str
         The name of this calendar. This will be the same as `source` if no name was specified when the calendar was created.
    num_event_types:int
         The number of distinct eventTypes in this calendar.
    num_events:int
         The number of dates that are marked as having an event in this calendar.
    project_id:[str]
         The project IDs of projects currently using this calendar.
    role:str
         The role the requesting user has on this calendar.
    source:str
         The name of the source file that was used to create this calendar.
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.DateTime(),
            t.Key("datetime_format"):  t.String(),
            t.Key("earliest_event"):  t.DateTime(),
            t.Key("id"):  t.String(),
            t.Key("latest_event"):  t.DateTime(),
            t.Key("multiseries_id_columns"):  t.List(t.Dict().allow_extra("*")),
            t.Key("name"):  t.String(),
            t.Key("num_event_types"):  t.Int(),
            t.Key("num_events"):  t.Int(),
            t.Key("project_id"):  t.List(t.Dict().allow_extra("*")),
            t.Key("role"):  t.String(),
            t.Key("source"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        datetime_format,
        earliest_event,
        id,
        latest_event,
        multiseries_id_columns,
        name,
        num_event_types,
        num_events,
        project_id,
        role,
        source,
    ):
        self.created = created
        self.datetime_format = datetime_format
        self.earliest_event = earliest_event
        self.id = id
        self.latest_event = latest_event
        self.multiseries_id_columns = multiseries_id_columns
        self.name = name
        self.num_event_types = num_event_types
        self.num_events = num_events
        self.project_id = project_id
        self.role = role
        self.source = source

    def __repr__(self):
        return (
            "CalendarRecord("
            "created={0.created}, "
            "datetime_format={0.datetime_format}, "
            "earliest_event={0.earliest_event}, "
            "id={0.id}, "
            "latest_event={0.latest_event}, "
            "multiseries_id_columns={0.multiseries_id_columns}, "
            "name={0.name}, "
            "num_event_types={0.num_event_types}, "
            "num_events={0.num_events}, "
            "project_id={0.project_id}, "
            "role={0.role}, "
            "source={0.source}, "
        ).format(self)
