#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Catalog(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The ID of the AI catalog dataset
    type:str
         Type name for this intake type. defaults to "dataset", must be one of ["dataset", ]
    dataset_version_id:str [optional]
         The ID of the AI catalog dataset version. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("dataset_version_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        type,
        dataset_version_id=None,
    ):
        self.dataset_id = dataset_id
        self.type = type
        self.dataset_version_id = dataset_version_id

    def __repr__(self):
        return (
            "Catalog("
            "dataset_id={0.dataset_id}, "
            "type={0.type}, "
            "dataset_version_id={0.dataset_version_id}, "
        ).format(self)
