#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CatalogDetailsRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    created_at:datetime
         The ISO 8601-formatted date and time indicating when this item was created in the catalog.
    created_by:str
         The full name or username of the user who added this item to the catalog.
    description:str, none_type
         Catalog item description.
    id:str
         Catalog item ID.
    message:str, none_type
         Details of exception(s) raised during ingestion process, if any.
    modified_at:datetime
         The ISO 8601-formatted date and time indicating changes to the Info field(s) of this catalog item.
    modified_by:str
         The full name or username of the user who last modified the Info field(s) of this catalog item.
    name:str
         Catalog item name.
    status:str, none_type
         For datasets, the current ingestion process state of this catalog item.
    tags:[str]
         List of catalog item tags in the lower case with no spaces.
    type:str
         Catalog item type.
    """
    _converter = t.Dict(
        {
            t.Key("created_at"):  t.DateTime(),
            t.Key("created_by"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("message"):  t.String(),
            t.Key("modified_at"):  t.DateTime(),
            t.Key("modified_by"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("status"):  t.String(),
            t.Key("tags"):  t.List(t.Dict().allow_extra("*")),
            t.Key("type"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_at,
        created_by,
        description,
        id,
        message,
        modified_at,
        modified_by,
        name,
        status,
        tags,
        type,
    ):
        self.created_at = created_at
        self.created_by = created_by
        self.description = description
        self.id = id
        self.message = message
        self.modified_at = modified_at
        self.modified_by = modified_by
        self.name = name
        self.status = status
        self.tags = tags
        self.type = type

    def __repr__(self):
        return (
            "CatalogDetailsRetrieveResponse("
            "created_at={0.created_at}, "
            "created_by={0.created_by}, "
            "description={0.description}, "
            "id={0.id}, "
            "message={0.message}, "
            "modified_at={0.modified_at}, "
            "modified_by={0.modified_by}, "
            "name={0.name}, "
            "status={0.status}, "
            "tags={0.tags}, "
            "type={0.type}, "
        ).format(self)
