#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CatalogExtendedDetailsResponse(APIObject):
    """
    Attributes
    ----------
    can_use_dataset_data:bool
         Indicates if the dataset data can be used.
    catalog_name:str
         Catalog item name.
    catalog_type:str
         Catalog item type.
    data_engine_query_id:str, none_type
         The ID of the catalog item data engine query.
    data_mesh_workspace_id:str, none_type
         The ID by which workspace is referenced in Data Mesh API.
    data_source_id:str, none_type
         The ID of the catalog item data source.
    description:str, none_type
         Catalog item description.
    error:str, none_type
         The latest error of the catalog item.
    id:str
         Catalog item ID.
    info_creation_date:str
         The creation date of the catalog item.
    info_creator_full_name:str
         The creator of the catalog item.
    info_modification_date:str
         The date when the dataset metadata was last modified. This field is only applicable if the catalog item is a dataset.
    info_modifier_full_name:str, none_type
         The user that last modified the dataset metadata. This field is only applicable if the catalog item is a dataset.
    is_data_engine_eligible:bool
         Indicates if the catalog item is eligible for use by the data engine.
    last_modification_date:str
         The date when the catalog item was last modified.
    last_modifier_full_name:str
         The user that last modified the catalog item.
    original_name:str
         Catalog item original name.
    processing_state:int, none_type
         The latest processing state of the catalog item.
    projects_used_in_count:int
         The number of projects that use the catalog item.
    relevance:float, none_type
         ElasticSearch score value or null if search done in Mongo.
    tags:[str]
         List of catalog item tags in the lower case with no spaces.
    uri:str, none_type
         The URI to the datasource from which the catalog item was created, if it is a dataset.
    user_blueprint_id:str, none_type
         The ID by which a user blueprint is referenced in User Blueprint API.
    is_first_version:bool [optional]
         Indicates if the catalog item is the first version.. 
    """
    _converter = t.Dict(
        {
            t.Key("can_use_dataset_data"):  t.Bool(),
            t.Key("catalog_name"):  t.String(),
            t.Key("catalog_type"):  t.String(),
            t.Key("data_engine_query_id"):  t.String(),
            t.Key("data_mesh_workspace_id"):  t.String(),
            t.Key("data_source_id"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("error"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("info_creation_date"):  t.String(),
            t.Key("info_creator_full_name"):  t.String(),
            t.Key("info_modification_date"):  t.String(),
            t.Key("info_modifier_full_name"):  t.String(),
            t.Key("is_data_engine_eligible"):  t.Bool(),
            t.Key("last_modification_date"):  t.String(),
            t.Key("last_modifier_full_name"):  t.String(),
            t.Key("original_name"):  t.String(),
            t.Key("processing_state"):  t.Int(),
            t.Key("projects_used_in_count"):  t.Int(),
            t.Key("relevance"):  t.Float(),
            t.Key("tags"):  t.List(t.Dict().allow_extra("*")),
            t.Key("uri"):  t.String(),
            t.Key("user_blueprint_id"):  t.String(),
            t.Key("is_first_version", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_use_dataset_data,
        catalog_name,
        catalog_type,
        data_engine_query_id,
        data_mesh_workspace_id,
        data_source_id,
        description,
        error,
        id,
        info_creation_date,
        info_creator_full_name,
        info_modification_date,
        info_modifier_full_name,
        is_data_engine_eligible,
        last_modification_date,
        last_modifier_full_name,
        original_name,
        processing_state,
        projects_used_in_count,
        relevance,
        tags,
        uri,
        user_blueprint_id,
        is_first_version=None,
    ):
        self.can_use_dataset_data = can_use_dataset_data
        self.catalog_name = catalog_name
        self.catalog_type = catalog_type
        self.data_engine_query_id = data_engine_query_id
        self.data_mesh_workspace_id = data_mesh_workspace_id
        self.data_source_id = data_source_id
        self.description = description
        self.error = error
        self.id = id
        self.info_creation_date = info_creation_date
        self.info_creator_full_name = info_creator_full_name
        self.info_modification_date = info_modification_date
        self.info_modifier_full_name = info_modifier_full_name
        self.is_data_engine_eligible = is_data_engine_eligible
        self.last_modification_date = last_modification_date
        self.last_modifier_full_name = last_modifier_full_name
        self.original_name = original_name
        self.processing_state = processing_state
        self.projects_used_in_count = projects_used_in_count
        self.relevance = relevance
        self.tags = tags
        self.uri = uri
        self.user_blueprint_id = user_blueprint_id
        self.is_first_version = is_first_version

    def __repr__(self):
        return (
            "CatalogExtendedDetailsResponse("
            "can_use_dataset_data={0.can_use_dataset_data}, "
            "catalog_name={0.catalog_name}, "
            "catalog_type={0.catalog_type}, "
            "data_engine_query_id={0.data_engine_query_id}, "
            "data_mesh_workspace_id={0.data_mesh_workspace_id}, "
            "data_source_id={0.data_source_id}, "
            "description={0.description}, "
            "error={0.error}, "
            "id={0.id}, "
            "info_creation_date={0.info_creation_date}, "
            "info_creator_full_name={0.info_creator_full_name}, "
            "info_modification_date={0.info_modification_date}, "
            "info_modifier_full_name={0.info_modifier_full_name}, "
            "is_data_engine_eligible={0.is_data_engine_eligible}, "
            "last_modification_date={0.last_modification_date}, "
            "last_modifier_full_name={0.last_modifier_full_name}, "
            "original_name={0.original_name}, "
            "processing_state={0.processing_state}, "
            "projects_used_in_count={0.projects_used_in_count}, "
            "relevance={0.relevance}, "
            "tags={0.tags}, "
            "uri={0.uri}, "
            "user_blueprint_id={0.user_blueprint_id}, "
            "is_first_version={0.is_first_version}, "
        ).format(self)
