#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.catalog_extended_details_response import CatalogExtendedDetailsResponse

class CatalogListSearchResponse(APIObject):
    """
    Attributes
    ----------
    cache_hit:bool, none_type
         Indicates if the catalog item is returned from the cache.
    count:int
         Number of catalog items returned on this page.
    data:[CatalogExtendedDetailsResponse]
         Detailed information for every found catalog item.
    next:str, none_type
         Location of the next page.
    previous:str, none_type
         Location of the previous page.
    total_count:int [optional]
         Total number of catalog items.. 
    """
    _converter = t.Dict(
        {
            t.Key("cache_hit"):  t.Bool(),
            t.Key("count"):  t.Int(),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
            t.Key("total_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        cache_hit,
        count,
        data,
        next,
        previous,
        total_count=None,
    ):
        self.cache_hit = cache_hit
        self.count = count
        self.data = data
        self.next = next
        self.previous = previous
        self.total_count = total_count

    def __repr__(self):
        return (
            "CatalogListSearchResponse("
            "cache_hit={0.cache_hit}, "
            "count={0.count}, "
            "data={0.data}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "total_count={0.total_count}, "
        ).format(self)
