#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ChallengerCreate(APIObject):
    """
    Attributes
    ----------
    model_package_id:str
         ID of the model package to add as a challenger.
    name:str
         Human-readable name for the challenger.
    prediction_environment_id:str [optional]
         ID of the Prediction Environment the challenger should use. If prediction environments are enabled, this is required. 
    """
    _converter = t.Dict(
        {
            t.Key("model_package_id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("prediction_environment_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_package_id,
        name,
        prediction_environment_id=None,
    ):
        self.model_package_id = model_package_id
        self.name = name
        self.prediction_environment_id = prediction_environment_id

    def __repr__(self):
        return (
            "ChallengerCreate("
            "model_package_id={0.model_package_id}, "
            "name={0.name}, "
            "prediction_environment_id={0.prediction_environment_id}, "
        ).format(self)
