#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.model_package_response import ModelPackageResponse
from datarobot.models.full_api.generated.model.model_response import ModelResponse
from datarobot.models.full_api.generated.model.prediction_environment_response import PredictionEnvironmentResponse

class ChallengerResponse(APIObject):
    """
    Attributes
    ----------
    id:str
         ID of the challenger.
    model:ModelResponse
        
    model_package:ModelPackageResponse
        
    name:str
         Name of the challenger.
    prediction_environment:PredictionEnvironmentResponse [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.String(),
            t.Key("model"):  t.Any(),
            t.Key("model_package"):  t.Any(),
            t.Key("name"):  t.String(),
            t.Key("prediction_environment", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        model,
        model_package,
        name,
        prediction_environment=None,
    ):
        self.id = id
        self.model = model
        self.model_package = model_package
        self.name = name
        self.prediction_environment = prediction_environment

    def __repr__(self):
        return (
            "ChallengerResponse("
            "id={0.id}, "
            "model={0.model}, "
            "model_package={0.model_package}, "
            "name={0.name}, "
            "prediction_environment={0.prediction_environment}, "
        ).format(self)
