#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ChangeRequestInfoResponse(APIObject):
    """
    Attributes
    ----------
    change_request_id:str
         ID of the Change Request.
    create_date:datetime
         Change Request creation date.
    entity_id:str
         ID of the modified entity.
    entity_name:str, none_type
         Name of the modified entity.
    requester:str
         Username of the account that initiated a Change Request.
    state:str
         Status of the Change Request.
    update_date:datetime, none_type
         Last date when Change Request was modified.
    updated_by:str, none_type
         Username of the account that last updated the Change Request.
    """
    _converter = t.Dict(
        {
            t.Key("change_request_id"):  t.String(),
            t.Key("create_date"):  t.DateTime(),
            t.Key("entity_id"):  t.String(),
            t.Key("entity_name"):  t.String(),
            t.Key("requester"):  t.String(),
            t.Key("state"):  t.String(),
            t.Key("update_date"):  t.DateTime(),
            t.Key("updated_by"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        change_request_id,
        create_date,
        entity_id,
        entity_name,
        requester,
        state,
        update_date,
        updated_by,
    ):
        self.change_request_id = change_request_id
        self.create_date = create_date
        self.entity_id = entity_id
        self.entity_name = entity_name
        self.requester = requester
        self.state = state
        self.update_date = update_date
        self.updated_by = updated_by

    def __repr__(self):
        return (
            "ChangeRequestInfoResponse("
            "change_request_id={0.change_request_id}, "
            "create_date={0.create_date}, "
            "entity_id={0.entity_id}, "
            "entity_name={0.entity_name}, "
            "requester={0.requester}, "
            "state={0.state}, "
            "update_date={0.update_date}, "
            "updated_by={0.updated_by}, "
        ).format(self)
