#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ClassMappingAggregationSettings(APIObject):
    """
    Attributes
    ----------
    aggregation_class_name:str [optional]
         The name of the class that will be assigned to all rows with aggregated classes. Should not match any excluded_from_aggregation or we will have 2 classes with the same name and no way to distinguish between them. This option is only available formulticlass projects. By default 'DR_RARE_TARGET_VALUES' is used.. 
    excluded_from_aggregation:[str] [optional]
         List of target values that should be guaranteed to kept as is, regardless of other settings..  if omitted the server will use the default value of []
    max_unaggregated_class_values:int [optional]
         The maximum number of unique labels before aggregation kicks in. Should be at least len(excludedFromAggregation) + 1 for multiclass and at least len(excludedFromAggregation) for multilabel..  if omitted the server will use the default value of 1000
    min_class_support:int [optional]
         Minimum number of instances necessary for each target value in the dataset. All values with fewer instances than this value will be aggregated.  if omitted the server will use the default value of 1
    """
    _converter = t.Dict(
        {
            t.Key("aggregation_class_name", optional=True):  t.String(),
            t.Key("excluded_from_aggregation", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("max_unaggregated_class_values", optional=True):  t.Int(),
            t.Key("min_class_support", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        aggregation_class_name=None,
        excluded_from_aggregation=None,
        max_unaggregated_class_values=None,
        min_class_support=None,
    ):
        self.aggregation_class_name = aggregation_class_name
        self.excluded_from_aggregation = excluded_from_aggregation
        self.max_unaggregated_class_values = max_unaggregated_class_values
        self.min_class_support = min_class_support

    def __repr__(self):
        return (
            "ClassMappingAggregationSettings("
            "aggregation_class_name={0.aggregation_class_name}, "
            "excluded_from_aggregation={0.excluded_from_aggregation}, "
            "max_unaggregated_class_values={0.max_unaggregated_class_values}, "
            "min_class_support={0.min_class_support}, "
        ).format(self)
