#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ClassificationBinDataResponse(APIObject):
    """
    Attributes
    ----------
    bin_end:float
         The end of the numeric range for the current bin. Note that `binEnd` - `binStart` should be a constant, modulo floating-point rounding error, for all bins in a single plot.
    bin_start:float
         The start of the numeric range for the current bin. Must be equal to the `binEnd` of the previous bin.
    negatives:int
         The number of records in the dataset where the model's predicted value falls into this bin and the target is negative.
    positives:int
         The number of records in the dataset where the model's predicted value falls into this bin and the target is positive.
    """
    _converter = t.Dict(
        {
            t.Key("bin_end"):  t.Float(),
            t.Key("bin_start"):  t.Float(),
            t.Key("negatives"):  t.Int(),
            t.Key("positives"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bin_end,
        bin_start,
        negatives,
        positives,
    ):
        self.bin_end = bin_end
        self.bin_start = bin_start
        self.negatives = negatives
        self.positives = positives

    def __repr__(self):
        return (
            "ClassificationBinDataResponse("
            "bin_end={0.bin_end}, "
            "bin_start={0.bin_start}, "
            "negatives={0.negatives}, "
            "positives={0.positives}, "
        ).format(self)
