#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_flag_object import FeatureFlagObject

class ClusterLicenseRetrieveResponseLicense(APIObject):
    """
    Attributes
    ----------
    concurrent_workers_count:int
         The number of allowed simultaneously running jobs(concurrent workers)
    expiration_timestamp:str
         The time of the license expiration in UTC ISO format,ex. 2020-12-21T23:59:59.000000Z
    expired:bool
         A value indicating whether the license has already expired
    feature_flags:{str: (FeatureFlagObject,)}
         An object containing enforced feature flags. Each key is a name of a feature flag and value is an object described below.
    max_deployment_limit:int
         The number of maximum deployments limit (0: unlimited)
    maximum_active_users:int
         The number of maximum active users allowed in the system(0: unlimited
    prepaid_deployment_limit:int
         The number of prepaid deployments limit (0: unlimited)
    """
    _converter = t.Dict(
        {
            t.Key("concurrent_workers_count"):  t.Int(),
            t.Key("expiration_timestamp"):  t.String(),
            t.Key("expired"):  t.Bool(),
            t.Key("feature_flags"):  t.Mapping(t.String(), t.Any()),
            t.Key("max_deployment_limit"):  t.Int(),
            t.Key("maximum_active_users"):  t.Int(),
            t.Key("prepaid_deployment_limit"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        concurrent_workers_count,
        expiration_timestamp,
        expired,
        feature_flags,
        max_deployment_limit,
        maximum_active_users,
        prepaid_deployment_limit,
    ):
        self.concurrent_workers_count = concurrent_workers_count
        self.expiration_timestamp = expiration_timestamp
        self.expired = expired
        self.feature_flags = feature_flags
        self.max_deployment_limit = max_deployment_limit
        self.maximum_active_users = maximum_active_users
        self.prepaid_deployment_limit = prepaid_deployment_limit

    def __repr__(self):
        return (
            "ClusterLicenseRetrieveResponseLicense("
            "concurrent_workers_count={0.concurrent_workers_count}, "
            "expiration_timestamp={0.expiration_timestamp}, "
            "expired={0.expired}, "
            "feature_flags={0.feature_flags}, "
            "max_deployment_limit={0.max_deployment_limit}, "
            "maximum_active_users={0.maximum_active_users}, "
            "prepaid_deployment_limit={0.prepaid_deployment_limit}, "
        ).format(self)
