#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ClusterLicenseRetrieveResponseUploadInfo(APIObject):
    """
    Attributes
    ----------
    upload_timestamp:str
         the time when the current license was uploaded in UTC ISO format, ex. '2020-12-21T23:59:59.000000Z'
    uploader_user_id:str
         Id of the user who uploaded the current license
    uploader_username:str
         The username of the user who uploaded the current license
    """
    _converter = t.Dict(
        {
            t.Key("upload_timestamp"):  t.String(),
            t.Key("uploader_user_id"):  t.String(),
            t.Key("uploader_username"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        upload_timestamp,
        uploader_user_id,
        uploader_username,
    ):
        self.upload_timestamp = upload_timestamp
        self.uploader_user_id = uploader_user_id
        self.uploader_username = uploader_username

    def __repr__(self):
        return (
            "ClusterLicenseRetrieveResponseUploadInfo("
            "upload_timestamp={0.upload_timestamp}, "
            "uploader_user_id={0.uploader_user_id}, "
            "uploader_username={0.uploader_username}, "
        ).format(self)
