#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Comment(APIObject):
    """
    Attributes
    ----------
    content:str
         Content of the comment, 10000 symbols max
    entity_id:str
         ID of the entity to post the comment to
    entity_type:str
         Type of the entity to post the comment to, currently only useCase is supported
    mentions:[str] [optional]
         A list of users IDs mentioned in the content. 
    """
    _converter = t.Dict(
        {
            t.Key("content"):  t.String(),
            t.Key("entity_id"):  t.String(),
            t.Key("entity_type"):  t.String(),
            t.Key("mentions", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        content,
        entity_id,
        entity_type,
        mentions=None,
    ):
        self.content = content
        self.entity_id = entity_id
        self.entity_type = entity_type
        self.mentions = mentions

    def __repr__(self):
        return (
            "Comment("
            "content={0.content}, "
            "entity_id={0.entity_id}, "
            "entity_type={0.entity_type}, "
            "mentions={0.mentions}, "
        ).format(self)
