#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.comment_user import CommentUser

class CommentRetrieve(APIObject):
    """
    Attributes
    ----------
    content:str
         Content of the comment
    created_at:str
         Timestamp when the comment was created
    created_by:CommentUser
        
    entity_id:str
         ID of the entity the comment posted to
    entity_type:str
         Type of the entity to post the comment to, currently only useCase is supported
    id:str
         ID of the comment
    mentions:[CommentUser]
         A list of users objects (see below) mentioned in the content
    updated_at:str
         Timestamp when the comment was updated
    """
    _converter = t.Dict(
        {
            t.Key("content"):  t.String(),
            t.Key("created_at"):  t.String(),
            t.Key("created_by"):  t.Any(),
            t.Key("entity_id"):  t.String(),
            t.Key("entity_type"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("mentions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("updated_at"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        content,
        created_at,
        created_by,
        entity_id,
        entity_type,
        id,
        mentions,
        updated_at,
    ):
        self.content = content
        self.created_at = created_at
        self.created_by = created_by
        self.entity_id = entity_id
        self.entity_type = entity_type
        self.id = id
        self.mentions = mentions
        self.updated_at = updated_at

    def __repr__(self):
        return (
            "CommentRetrieve("
            "content={0.content}, "
            "created_at={0.created_at}, "
            "created_by={0.created_by}, "
            "entity_id={0.entity_id}, "
            "entity_type={0.entity_type}, "
            "id={0.id}, "
            "mentions={0.mentions}, "
            "updated_at={0.updated_at}, "
        ).format(self)
