#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CommentUpdate(APIObject):
    """
    Attributes
    ----------
    content:str
         Updated content of the comment, 10000 symbols max
    mentions:[str] [optional]
         A list of users IDs mentioned in the content. 
    """
    _converter = t.Dict(
        {
            t.Key("content"):  t.String(),
            t.Key("mentions", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        content,
        mentions=None,
    ):
        self.content = content
        self.mentions = mentions

    def __repr__(self):
        return (
            "CommentUpdate("
            "content={0.content}, "
            "mentions={0.mentions}, "
        ).format(self)
