#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ComplianceDocTemplateCreate(APIObject):
    """
    Attributes
    ----------
    name:str
         Name of the new template. Must be unique among templates created by the user.
    sections:[bool, date, datetime, dict, float, int, list, str, none_type]
         List of section objects representing the structure of the document. Each section can have sub-sections that have the same schema as the parent section, i.e., the structure is recursive. The number of nested sections allowed is 5. The total number of sections allowed is 500. 
    labels:[str] [optional]
         Names of the labels to assign to the template.. 
    project_type:str [optional]
         Type of project template.. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("sections"):  t.List(t.Dict().allow_extra("*")),
            t.Key("labels", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("project_type", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        sections,
        labels=None,
        project_type=None,
    ):
        self.name = name
        self.sections = sections
        self.labels = labels
        self.project_type = project_type

    def __repr__(self):
        return (
            "ComplianceDocTemplateCreate("
            "name={0.name}, "
            "sections={0.sections}, "
            "labels={0.labels}, "
            "project_type={0.project_type}, "
        ).format(self)
