#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ComplianceDocTemplateUpdate(APIObject):
    """
    Attributes
    ----------
    description:str [optional]
         New description for the template.. 
    labels:[str] [optional]
         Names of the labels to assign to the template.. 
    name:str [optional]
         New name for the template. Must be unique among templates created by the user.. 
    project_type:str [optional]
         Type of project template.. 
    sections:[bool, date, datetime, dict, float, int, list, str, none_type] [optional]
         List of section objects representing the structure of the document. Each section can have sub-sections that have the same schema as the parent section, i.e., the structure is recursive. The number of nested sections allowed is 5. The total number of sections allowed is 500. . 
    """
    _converter = t.Dict(
        {
            t.Key("description", optional=True):  t.String(),
            t.Key("labels", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("name", optional=True):  t.String(),
            t.Key("project_type", optional=True):  t.String(),
            t.Key("sections", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        description=None,
        labels=None,
        name=None,
        project_type=None,
        sections=None,
    ):
        self.description = description
        self.labels = labels
        self.name = name
        self.project_type = project_type
        self.sections = sections

    def __repr__(self):
        return (
            "ComplianceDocTemplateUpdate("
            "description={0.description}, "
            "labels={0.labels}, "
            "name={0.name}, "
            "project_type={0.project_type}, "
            "sections={0.sections}, "
        ).format(self)
