#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.actual_percentages import ActualPercentages
from datarobot.models.full_api.generated.model.predicted_percentages import PredictedPercentages

class ConfusionChartClassMatrix(APIObject):
    """
    Attributes
    ----------
    actual_count:int
         number of times this class is seen in the validation data
    class_name:str
         name of the class
    confusion_matrix_one_vs_all:[[int]]
         2d array representing 2x2 one vs all matrix. This represents the True/False Negative/Positive rates as integer for each class. The data structure looks like: ``[ [ True Negative, False Positive ], [ False Negative, True Positive ] ]``
    f1:float
         F1 score
    precision:float
         precision score
    predicted_count:int
         number of times this class has been predicted for the validation data
    recall:float
         recall score
    was_actual_percentages:[ActualPercentages]
         one vs all actual percentages in a format specified below
    was_predicted_percentages:[PredictedPercentages]
         one vs all predicted percentages in a format specified below
    """
    _converter = t.Dict(
        {
            t.Key("actual_count"):  t.Int(),
            t.Key("class_name"):  t.String(),
            t.Key("confusion_matrix_one_vs_all"):  t.List(t.Dict().allow_extra("*")),
            t.Key("f1"):  t.Float(),
            t.Key("precision"):  t.Float(),
            t.Key("predicted_count"):  t.Int(),
            t.Key("recall"):  t.Float(),
            t.Key("was_actual_percentages"):  t.List(t.Dict().allow_extra("*")),
            t.Key("was_predicted_percentages"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual_count,
        class_name,
        confusion_matrix_one_vs_all,
        f1,
        precision,
        predicted_count,
        recall,
        was_actual_percentages,
        was_predicted_percentages,
    ):
        self.actual_count = actual_count
        self.class_name = class_name
        self.confusion_matrix_one_vs_all = confusion_matrix_one_vs_all
        self.f1 = f1
        self.precision = precision
        self.predicted_count = predicted_count
        self.recall = recall
        self.was_actual_percentages = was_actual_percentages
        self.was_predicted_percentages = was_predicted_percentages

    def __repr__(self):
        return (
            "ConfusionChartClassMatrix("
            "actual_count={0.actual_count}, "
            "class_name={0.class_name}, "
            "confusion_matrix_one_vs_all={0.confusion_matrix_one_vs_all}, "
            "f1={0.f1}, "
            "precision={0.precision}, "
            "predicted_count={0.predicted_count}, "
            "recall={0.recall}, "
            "was_actual_percentages={0.was_actual_percentages}, "
            "was_predicted_percentages={0.was_predicted_percentages}, "
        ).format(self)
