#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.confusion_chart_class_matrix import ConfusionChartClassMatrix

class ConfusionChartData(APIObject):
    """
    Attributes
    ----------
    class_metrics:[ConfusionChartClassMatrix]
         per-class information including one vs all scores in a format specified below
    classes:[str]
         class labels from the dataset, union of row classes & column classes. This field is deprecated as of v2.13. The rows and columns may have different class labels when using query parameters to retrieve a slice of the matrix; please use 'rowClasses' and 'colClasses' instead.
    col_classes:[str]
         class labels on columns of confusion matrix
    confusion_matrix:[[int]]
         2d array of ints representing confusion matrix, aligned with `rowClasses` and 'colClasses'array. For confusionMatrix[A][B] we can get an integer that represents the number of times 'if class with index A was correct we have class with index B predicted' (if the orientation is 'actual').
    row_classes:[str]
         class labels on rows of confusion matrix
    """
    _converter = t.Dict(
        {
            t.Key("class_metrics"):  t.List(t.Dict().allow_extra("*")),
            t.Key("classes"):  t.List(t.Dict().allow_extra("*")),
            t.Key("col_classes"):  t.List(t.Dict().allow_extra("*")),
            t.Key("confusion_matrix"):  t.List(t.Dict().allow_extra("*")),
            t.Key("row_classes"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        class_metrics,
        classes,
        col_classes,
        confusion_matrix,
        row_classes,
    ):
        self.class_metrics = class_metrics
        self.classes = classes
        self.col_classes = col_classes
        self.confusion_matrix = confusion_matrix
        self.row_classes = row_classes

    def __repr__(self):
        return (
            "ConfusionChartData("
            "class_metrics={0.class_metrics}, "
            "classes={0.classes}, "
            "col_classes={0.col_classes}, "
            "confusion_matrix={0.confusion_matrix}, "
            "row_classes={0.row_classes}, "
        ).format(self)
