#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.confusion_chart_data import ConfusionChartData

class ConfusionChartRetrieveForDatasets(APIObject):
    """
    Attributes
    ----------
    columns:[int]
         [colStart, colEnd] column dimension of confusion matrix in response
    data:ConfusionChartData
        
    dataset_id:str
         The datasetId to retrieve a Confusion chart from.
    number_of_classes:int
         count of classes in full confusion matrix.
    rows:[int]
         [rowStart, rowEnd] row dimension of confusion matrix in response
    total_matrix_sum:int
         sum of all values in full confusion matrix
    """
    _converter = t.Dict(
        {
            t.Key("columns"):  t.List(t.Dict().allow_extra("*")),
            t.Key("data"):  t.Any(),
            t.Key("dataset_id"):  t.String(),
            t.Key("number_of_classes"):  t.Int(),
            t.Key("rows"):  t.List(t.Dict().allow_extra("*")),
            t.Key("total_matrix_sum"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        columns,
        data,
        dataset_id,
        number_of_classes,
        rows,
        total_matrix_sum,
    ):
        self.columns = columns
        self.data = data
        self.dataset_id = dataset_id
        self.number_of_classes = number_of_classes
        self.rows = rows
        self.total_matrix_sum = total_matrix_sum

    def __repr__(self):
        return (
            "ConfusionChartRetrieveForDatasets("
            "columns={0.columns}, "
            "data={0.data}, "
            "dataset_id={0.dataset_id}, "
            "number_of_classes={0.number_of_classes}, "
            "rows={0.rows}, "
            "total_matrix_sum={0.total_matrix_sum}, "
        ).format(self)
