#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ConfusionChartRetrieveMetadataForDatasets(APIObject):
    """
    Attributes
    ----------
    class_names:[str]
         list of all class names in the full confusion matrix, sorted by the `orderBy` parameter.
    dataset_id:str
         The dataset to retrieve a Confusion chart from.
    model_id:str
         The model to retrieve a Confusion chart from.
    project_id:str
         The project to retrieve a Confusion chart from.
    relevant_classes_positions:[[int]]
         Matrix to highlight important cell blocks in the confusion chart. Intended to represent a thumbnail view, where the relevantClassesPositions array has a 1 in thumbnail cells that are of interest, and 0 otherwise. The dimensions of the implied thumbnail will not match those of the confusion matrix, e.g. a twenty-class confusion matrix may have a 2x2 thumbnail.
    total_matrix_sum:int
         Sum of all values in the full confusion matrix (equal to the number of points considered).
    """
    _converter = t.Dict(
        {
            t.Key("class_names"):  t.List(t.Dict().allow_extra("*")),
            t.Key("dataset_id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("relevant_classes_positions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("total_matrix_sum"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        class_names,
        dataset_id,
        model_id,
        project_id,
        relevant_classes_positions,
        total_matrix_sum,
    ):
        self.class_names = class_names
        self.dataset_id = dataset_id
        self.model_id = model_id
        self.project_id = project_id
        self.relevant_classes_positions = relevant_classes_positions
        self.total_matrix_sum = total_matrix_sum

    def __repr__(self):
        return (
            "ConfusionChartRetrieveMetadataForDatasets("
            "class_names={0.class_names}, "
            "dataset_id={0.dataset_id}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "relevant_classes_positions={0.relevant_classes_positions}, "
            "total_matrix_sum={0.total_matrix_sum}, "
        ).format(self)
