#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ConnectorFieldSchema(APIObject):
    """
    Attributes
    ----------
    choices:[str]
         If non-empty, a list of all possible values for a parameter.
    default:str
         Default value of the connector parameter.
    description:str
         Description of the parameter.
    name:str
         Name of the connector parameter.
    required:bool
         Whether or not the parameter is required for a connection.
    visible_by_default:bool
         Whether or not the parameter should be shown in the UI by default.
    """
    _converter = t.Dict(
        {
            t.Key("choices"):  t.List(t.Dict().allow_extra("*")),
            t.Key("default"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("required"):  t.Bool(),
            t.Key("visible_by_default"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        choices,
        default,
        description,
        name,
        required,
        visible_by_default,
    ):
        self.choices = choices
        self.default = default
        self.description = description
        self.name = name
        self.required = required
        self.visible_by_default = visible_by_default

    def __repr__(self):
        return (
            "ConnectorFieldSchema("
            "choices={0.choices}, "
            "default={0.default}, "
            "description={0.description}, "
            "name={0.name}, "
            "required={0.required}, "
            "visible_by_default={0.visible_by_default}, "
        ).format(self)
