#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CreateCredentialsResponse(APIObject):
    """
    Attributes
    ----------
    creation_date:datetime
         ISO-8601 formatted date/time when these credentials were created.
    credential_id:str
         ID of these credentials.
    name:str
         Name of these credentials.
    credential_type:str [optional]
         Type of credentials..  if omitted the server will use the default value of "basic"
    description:str [optional]
         Description of these credentials.. 
    """
    _converter = t.Dict(
        {
            t.Key("creation_date"):  t.DateTime(),
            t.Key("credential_id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("credential_type", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        creation_date,
        credential_id,
        name,
        credential_type=None,
        description=None,
    ):
        self.creation_date = creation_date
        self.credential_id = credential_id
        self.name = name
        self.credential_type = credential_type
        self.description = description

    def __repr__(self):
        return (
            "CreateCredentialsResponse("
            "creation_date={0.creation_date}, "
            "credential_id={0.credential_id}, "
            "name={0.name}, "
            "credential_type={0.credential_type}, "
            "description={0.description}, "
        ).format(self)
