#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CreateFeaturelist(APIObject):
    """
    Attributes
    ----------
    features:[str]
         List of features for new featurelist.
    name:str
         New featurelist name.
    skip_datetime_partition_column:bool [optional]
         Whether featurelist should contain datetime partition column..  if omitted the server will use the default value of False
    """
    _converter = t.Dict(
        {
            t.Key("features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("name"):  t.String(),
            t.Key("skip_datetime_partition_column", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        features,
        name,
        skip_datetime_partition_column=None,
    ):
        self.features = features
        self.name = name
        self.skip_datetime_partition_column = skip_datetime_partition_column

    def __repr__(self):
        return (
            "CreateFeaturelist("
            "features={0.features}, "
            "name={0.name}, "
            "skip_datetime_partition_column={0.skip_datetime_partition_column}, "
        ).format(self)
