#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CreatePredictionFromDataset(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The dataset to compute predictions for - must have previously been uploaded.
    model_id:str
         The model to make predictions on.
    actual_value_column:str [optional]
         For time series projects only. Actual value column name, valid for the prediction files if the project is unsupervised and the dataset is considered as bulk predictions dataset. This value is optional.. 
    explanation_algorithm:str [optional]
         If set to `shap`, the response will include prediction explanations based on the SHAP explainer (SHapley Additive exPlanations). Defaults to null (no prediction explanations)..  if omitted the server will use the default value of "shap"
    forecast_point:datetime [optional]
         For time series projects only. The time in the dataset relative to which predictions are generated. This value is optional. If not specified the default value is the value in the row with the latest specified timestamp. Specifying this value for a project that is not a time series project will result in an error.. 
    include_fdw_counts:bool [optional]
         For time series projects with partial history only. Indicates if feature derivation window counts `featureDerivationWindowCounts` will be part of the response..  if omitted the server will use the default value of False
    include_prediction_intervals:bool [optional]
         Specifies whether prediction intervals should be calculated for this request. Defaults to True if `predictionIntervalsSize` is specified, otherwise defaults to False.. 
    max_explanations:int [optional]
         Specifies the maximum number of explanation values that should be returned for each row, ordered by absolute value, greatest to least. In the case of 'shap': If not set, explanations are returned for all features. If the number of features is greater than the 'maxExplanations', the sum of remaining values will also be returned as 'shapRemainingTotal'. Defaults to null for datasets narrower than 100 columns, defaults to 100 for datasets wider than 100 columns. Cannot be set if 'explanationAlgorithm' is omitted.. 
    prediction_intervals_size:int [optional]
         Represents the percentile to use for the size of the prediction intervals. Defaults to 80 if `includePredictionIntervals` is True.. 
    prediction_threshold:float [optional]
         Threshold used for binary classification in predictions. Accepts values from 0.0 to 1.0. If not specified, model default prediction threshold will be used.. 
    predictions_end_date:datetime [optional]
         The end date for bulk predictions, exclusive. Used for time series projects only. Note that this parameter is used for generating historical predictions using the training data, not for future predictions. If not specified, the dataset is not considered as a bulk predictions dataset. This parameter should be provided in conjunction with a ``predictionsStartDate``, and cannot be provided with the ``forecastPoint`` parameter.. 
    predictions_start_date:datetime [optional]
         The start date for bulk predictions. Used for time series projects only. Note that this parameter is used for generating historical predictions using the training data, not for future predictions. If not specified, the dataset is not considered as a bulk predictions dataset. This parameter should be provided in conjunction with a ``predictionsEndDate``, and cannot be provided with the ``forecastPoint`` parameter.. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("actual_value_column", optional=True):  t.String(),
            t.Key("explanation_algorithm", optional=True):  t.String(),
            t.Key("forecast_point", optional=True):  t.DateTime(),
            t.Key("include_fdw_counts", optional=True):  t.Bool(),
            t.Key("include_prediction_intervals", optional=True):  t.Bool(),
            t.Key("max_explanations", optional=True):  t.Int(),
            t.Key("prediction_intervals_size", optional=True):  t.Int(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
            t.Key("predictions_end_date", optional=True):  t.DateTime(),
            t.Key("predictions_start_date", optional=True):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        model_id,
        actual_value_column=None,
        explanation_algorithm=None,
        forecast_point=None,
        include_fdw_counts=None,
        include_prediction_intervals=None,
        max_explanations=None,
        prediction_intervals_size=None,
        prediction_threshold=None,
        predictions_end_date=None,
        predictions_start_date=None,
    ):
        self.dataset_id = dataset_id
        self.model_id = model_id
        self.actual_value_column = actual_value_column
        self.explanation_algorithm = explanation_algorithm
        self.forecast_point = forecast_point
        self.include_fdw_counts = include_fdw_counts
        self.include_prediction_intervals = include_prediction_intervals
        self.max_explanations = max_explanations
        self.prediction_intervals_size = prediction_intervals_size
        self.prediction_threshold = prediction_threshold
        self.predictions_end_date = predictions_end_date
        self.predictions_start_date = predictions_start_date

    def __repr__(self):
        return (
            "CreatePredictionFromDataset("
            "dataset_id={0.dataset_id}, "
            "model_id={0.model_id}, "
            "actual_value_column={0.actual_value_column}, "
            "explanation_algorithm={0.explanation_algorithm}, "
            "forecast_point={0.forecast_point}, "
            "include_fdw_counts={0.include_fdw_counts}, "
            "include_prediction_intervals={0.include_prediction_intervals}, "
            "max_explanations={0.max_explanations}, "
            "prediction_intervals_size={0.prediction_intervals_size}, "
            "prediction_threshold={0.prediction_threshold}, "
            "predictions_end_date={0.predictions_end_date}, "
            "predictions_start_date={0.predictions_start_date}, "
        ).format(self)
