#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CreateTrainingPrediction(APIObject):
    """
    Attributes
    ----------
    data_subset:str
         Subset of data predicted on: The value \"all\" returns predictions for all rows in the dataset including data used for training, validation, holdout and any rows discarded. This is not available for large datasets or projects created with Date/Time partitioning. The value \"validationAndHoldout\" returns predictions for the rows used to calculate the validation score and the holdout score. Not available for large projects or Date/Time projects for models trained into the validation set. The value \"holdout\" returns predictions for the rows used to calculate the holdout score. Not available for projects created without a holdout or for models trained into holdout for large datasets or created with Date/Time partitioning. The value \"allBacktests\" returns predictions for the rows used to calculate the backtesting scores for Date/Time projects. The value \"validation\" returns predictions for the rows used to calculate the validation score.. defaults to "all", must be one of ["validationAndHoldout", "allBacktests", "validation", "all", "holdout", ]
    model_id:str
         The model to make predictions on
    explanation_algorithm:str [optional]
         If set to \"shap\", the response will include prediction explanations based on the SHAP explainer (SHapley Additive exPlanations). Defaults to null (no prediction explanations). 
    max_explanations:int [optional]
         Specifies the maximum number of explanation values that should be returned for each row, ordered by absolute value, greatest to least. In the case of \"shap\": If not set, explanations are returned for all features. If the number of features is greater than the \"maxExplanations\", the sum of remaining values will also be returned as \"shapRemainingTotal\". Defaults to null for datasets narrower than 100 columns, defaults to 100 for datasets wider than 100 columns. Cannot be set if \"explanationAlgorithm\" is omitted.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_subset"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("explanation_algorithm", optional=True):  t.String(),
            t.Key("max_explanations", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_subset,
        model_id,
        explanation_algorithm=None,
        max_explanations=None,
    ):
        self.data_subset = data_subset
        self.model_id = model_id
        self.explanation_algorithm = explanation_algorithm
        self.max_explanations = max_explanations

    def __repr__(self):
        return (
            "CreateTrainingPrediction("
            "data_subset={0.data_subset}, "
            "model_id={0.model_id}, "
            "explanation_algorithm={0.explanation_algorithm}, "
            "max_explanations={0.max_explanations}, "
        ).format(self)
