#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.data_engine_dataset import DataEngineDataset

class CreateWorkspaceState(APIObject):
    """
    Attributes
    ----------
    language:str
         Language of the Data Engine query.. defaults to "SQL", must be one of ["SQL", ]
    query:str
         Actual body of the Data Engine query.
    datasets:[DataEngineDataset] [optional]
         Source datasets in the Data Engine workspace.. 
    """
    _converter = t.Dict(
        {
            t.Key("language"):  t.String(),
            t.Key("query"):  t.String(),
            t.Key("datasets", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        language,
        query,
        datasets=None,
    ):
        self.language = language
        self.query = query
        self.datasets = datasets

    def __repr__(self):
        return (
            "CreateWorkspaceState("
            "language={0.language}, "
            "query={0.query}, "
            "datasets={0.datasets}, "
        ).format(self)
