#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CreatedDatasetResponse(APIObject):
    """
    Attributes
    ----------
    catalog_id:str
         The ID of the catalog entry.
    catalog_version_id:str
         The ID of the latest version of the catalog entry.
    status_id:str
         ID that can be used with :http:get:`/api/v2/status/(statusId)/` to poll for the testing job's status.
    """
    _converter = t.Dict(
        {
            t.Key("catalog_id"):  t.String(),
            t.Key("catalog_version_id"):  t.String(),
            t.Key("status_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog_id,
        catalog_version_id,
        status_id,
    ):
        self.catalog_id = catalog_id
        self.catalog_version_id = catalog_version_id
        self.status_id = status_id

    def __repr__(self):
        return (
            "CreatedDatasetResponse("
            "catalog_id={0.catalog_id}, "
            "catalog_version_id={0.catalog_version_id}, "
            "status_id={0.status_id}, "
        ).format(self)
