#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CredentialId(APIObject):
    """
    Attributes
    ----------
    credential_id:str
         The ID of the set of credentials to use instead of user and password. Note that with this change, username and password will become optional.
    catalog_version_id:str [optional]
         The ID of the latest version of the catalog entry.. 
    url:str [optional]
         The link to retrieve more detailed information about the entity that uses this catalog dataset.. 
    """
    _converter = t.Dict(
        {
            t.Key("credential_id"):  t.String(),
            t.Key("catalog_version_id", optional=True):  t.String(),
            t.Key("url", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_id,
        catalog_version_id=None,
        url=None,
    ):
        self.credential_id = credential_id
        self.catalog_version_id = catalog_version_id
        self.url = url

    def __repr__(self):
        return (
            "CredentialId("
            "credential_id={0.credential_id}, "
            "catalog_version_id={0.catalog_version_id}, "
            "url={0.url}, "
        ).format(self)
