#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.credentials_to_add import CredentialsToAdd

class CredentialsAssociationUpdate(APIObject):
    """
    Attributes
    ----------
    credentials_to_add:[CredentialsToAdd] [optional]
         Objects to associate with given credentials.. 
    credentials_to_remove:[str] [optional]
         Object IDs, each of which identifies an object to be disassociated from this credential. To see which objects are currently associated, see the response from :http:get:`/api/v2/credentials/(credentialId)/associations/`.. 
    """
    _converter = t.Dict(
        {
            t.Key("credentials_to_add", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("credentials_to_remove", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credentials_to_add=None,
        credentials_to_remove=None,
    ):
        self.credentials_to_add = credentials_to_add
        self.credentials_to_remove = credentials_to_remove

    def __repr__(self):
        return (
            "CredentialsAssociationUpdate("
            "credentials_to_add={0.credentials_to_add}, "
            "credentials_to_remove={0.credentials_to_remove}, "
        ).format(self)
