#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.credentials_body_one_of import CredentialsBodyOneOf
from datarobot.models.full_api.generated.model.credentials_body_one_of1 import CredentialsBodyOneOf1
from datarobot.models.full_api.generated.model.credentials_body_one_of2 import CredentialsBodyOneOf2
from datarobot.models.full_api.generated.model.credentials_body_one_of3 import CredentialsBodyOneOf3
from datarobot.models.full_api.generated.model.credentials_body_one_of4 import CredentialsBodyOneOf4
from datarobot.models.full_api.generated.model.credentials_body_one_of5 import CredentialsBodyOneOf5
from datarobot.models.full_api.generated.model.credentials_body_one_of6 import CredentialsBodyOneOf6
from datarobot.models.full_api.generated.model.gcp_key import GCPKey

class CredentialsBody(APIObject):
    """
    Attributes
    ----------
    credential_type:str
         Credentials type.. defaults to "adls_gen2_oauth", must be one of ["adls_gen2_oauth", ]
    description:str [optional]
         Credentials description.. 
    snowflake_account_name:str [optional]
         Snowflake account name.. 
    aws_access_key_id:str [optional]
         AWS access key ID.. 
    aws_secret_access_key:str [optional]
         AWS secret access key.. 
    aws_session_token:str [optional]
         AWS session token.. 
    client_id:str [optional]
         Snowflake OAUTH client ID.. 
    client_secret:str [optional]
         Snowflake OAUTH client secret.. 
    name:str [optional]
         Credentials name.. 
    password:str [optional]
         Password to store for this credentials.. 
    user:str [optional]
         Username to store for this credentials.. 
    refresh_token:str [optional]
         OAUTH token.. 
    token:str [optional]
         OAUTH token.. 
    gcp_key:GCPKey [optional]
         
    azure_connection_string:str [optional]
         Azure connection string.. 
    """
    _converter = t.Dict(
        {
            t.Key("credential_type"):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("snowflake_account_name", optional=True):  t.String(),
            t.Key("aws_access_key_id", optional=True):  t.String(),
            t.Key("aws_secret_access_key", optional=True):  t.String(),
            t.Key("aws_session_token", optional=True):  t.String(),
            t.Key("client_id", optional=True):  t.String(),
            t.Key("client_secret", optional=True):  t.String(),
            t.Key("name", optional=True):  t.String(),
            t.Key("password", optional=True):  t.String(),
            t.Key("user", optional=True):  t.String(),
            t.Key("refresh_token", optional=True):  t.String(),
            t.Key("token", optional=True):  t.String(),
            t.Key("gcp_key", optional=True):  t.Any(),
            t.Key("azure_connection_string", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_type,
        description=None,
        snowflake_account_name=None,
        aws_access_key_id=None,
        aws_secret_access_key=None,
        aws_session_token=None,
        client_id=None,
        client_secret=None,
        name=None,
        password=None,
        user=None,
        refresh_token=None,
        token=None,
        gcp_key=None,
        azure_connection_string=None,
    ):
        self.credential_type = credential_type
        self.description = description
        self.snowflake_account_name = snowflake_account_name
        self.aws_access_key_id = aws_access_key_id
        self.aws_secret_access_key = aws_secret_access_key
        self.aws_session_token = aws_session_token
        self.client_id = client_id
        self.client_secret = client_secret
        self.name = name
        self.password = password
        self.user = user
        self.refresh_token = refresh_token
        self.token = token
        self.gcp_key = gcp_key
        self.azure_connection_string = azure_connection_string

    def __repr__(self):
        return (
            "CredentialsBody("
            "credential_type={0.credential_type}, "
            "description={0.description}, "
            "snowflake_account_name={0.snowflake_account_name}, "
            "aws_access_key_id={0.aws_access_key_id}, "
            "aws_secret_access_key={0.aws_secret_access_key}, "
            "aws_session_token={0.aws_session_token}, "
            "client_id={0.client_id}, "
            "client_secret={0.client_secret}, "
            "name={0.name}, "
            "password={0.password}, "
            "user={0.user}, "
            "refresh_token={0.refresh_token}, "
            "token={0.token}, "
            "gcp_key={0.gcp_key}, "
            "azure_connection_string={0.azure_connection_string}, "
        ).format(self)
