#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CredentialsBodyOneOf(APIObject):
    """
    Attributes
    ----------
    name:str
         Credentials name.
    password:str
         Password to store for this credentials.
    user:str
         Username to store for this credentials.
    credential_type:str [optional]
         Credentials type..  if omitted the server will use the default value of "basic"
    description:str [optional]
         Credentials description.. 
    snowflake_account_name:str [optional]
         Snowflake account name.. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("password"):  t.String(),
            t.Key("user"):  t.String(),
            t.Key("credential_type", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("snowflake_account_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        password,
        user,
        credential_type=None,
        description=None,
        snowflake_account_name=None,
    ):
        self.name = name
        self.password = password
        self.user = user
        self.credential_type = credential_type
        self.description = description
        self.snowflake_account_name = snowflake_account_name

    def __repr__(self):
        return (
            "CredentialsBodyOneOf("
            "name={0.name}, "
            "password={0.password}, "
            "user={0.user}, "
            "credential_type={0.credential_type}, "
            "description={0.description}, "
            "snowflake_account_name={0.snowflake_account_name}, "
        ).format(self)
