#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class CredentialsBodyOneOf1(APIObject):
    """
    Attributes
    ----------
    credential_type:str
         Credentials type.. defaults to "oauth", must be one of ["oauth", ]
    name:str
         Credentials name.
    refresh_token:str
         OAUTH token.
    token:str
         OAUTH token.
    description:str [optional]
         Credentials description.. 
    """
    _converter = t.Dict(
        {
            t.Key("credential_type"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("refresh_token"):  t.String(),
            t.Key("token"):  t.String(),
            t.Key("description", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_type,
        name,
        refresh_token,
        token,
        description=None,
    ):
        self.credential_type = credential_type
        self.name = name
        self.refresh_token = refresh_token
        self.token = token
        self.description = description

    def __repr__(self):
        return (
            "CredentialsBodyOneOf1("
            "credential_type={0.credential_type}, "
            "name={0.name}, "
            "refresh_token={0.refresh_token}, "
            "token={0.token}, "
            "description={0.description}, "
        ).format(self)
